﻿using Microsoft.Practices.Prism.Logging;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Shell
{
    public class SimpleLogger: ILoggerFacade
    {
        /// <summary>
        /// Nasz prosty logger, wypisuje wszystko w konsoli debug
        /// </summary>
        /// <param name="message">Wiadomość do wypisania.</param>
        /// <param name="category">Kategoria wiadomości.</param>
        /// <param name="priority">Priorytet wiadomości</param>
        public void Log(string message, Category category, Priority priority)
        {
            switch (category)
            {
                case Category.Debug:
                    Debug.Write("Debug:" + message);
                    break;
                case Category.Warn:
                    Debug.Write("Warn:" + message);
                    break;
                case Category.Exception:
                    Debug.Write("Exception:" + message);
                    break;
                case Category.Info:
                    Debug.Write("Info:" + message);
                    break;
            }
        }
    }
}
